#!/bin/bash

#high-level token, show debug background color when connenting
hlt_sdbc_IsPresent=false

#high-level token, show auto disconnection details
hlt_sadd_IsPresent=false

#high-level token, enable second ethernet interface
hlt_debuginterface_IsPresent=false
hlt_debuginterface=""

#high-level token, enable full logging
hlt_efl_IsPresent=false

#high-level token, enable statistics logging
hlt_esl_IsPresent=false

#token to enable HDCP check
HdcpCheck=false

#token to enable sview
sview=false

#token to enable SCDC check
ScdcCheck=false

#token to hide no signal preview
HideNoSignal=false

#token to not use virtual USB devices
DoNotUseVirtualUsbDevices=false

#token for RGB_limited_workaround_disable
RGB_limited_workaround_disable=false

#logging configuration file
sv2_device_config_file="/usr/local/SV2/SV2.Device.exe.config"

#SimpleSetting configuration file
rw_config_simple_setting="/rw/config/rx.simplesettings"

#high-level token, disable MaQoS
hlt_dm_IsPresent=false

#high-level token - enable timings logging
hlt_etl_IsPresent=false

#high-level token set the XmslLogLevel to 0
hlt_xll0=false

#high-level token set the XmslLogLevel to 1
hlt_xll1=false

#high-level token set the XmslLogLevel to 2
hlt_xll2=false

#high-level token set the XmslLogLevel to 3
hlt_xll3=false

#high-level token set the XmslLogLevel to 4
hlt_xll4=false

#high-level token, periodic compositor capture on receiver
hlt_pcc_IsPresent=false

#debug option for background color
hlt_edbc=false

#high-level token do MtxEventTracer
MtxEventTracer=false

#token to enable Vital signs monitoring 
hlt_vsv=""

#debug option for Active Directory validation with nested groups
hlt_adng=false

#high-level token do edidoverride
#Example: edidoverride0_00-FF-FF-FF-FF-FF-FF-00-10-AC-EA-40-53-32-50-46-12-1C-01-04-A5-3C-22-78-3A-EE-95-A3-54-4C-99-26-0F-50-54-A5-4B-00-71-4F-A9-40-81-80-D1-C0-01-01-01-01-01-01-01-01-56-5E-00-A0-A0-A0-29-50-30-20-35-00-55-50-21-00-00-1A-00-00-00-FF-00-4A-30-58-59-4E-38-34-55-46-50-32-53-0A-00-00-00-FC-00-44-45-4C-4C-20-55-32-37-31-37-44-0A-20-00-00-00-FD-00-32-4B-1E-58-19-01-0A-20-20-20-20-20-20-01-3C-02-03-1C-F1-4F-90-05-04-03-02-07-16-01-06-11-12-15-13-14-1F-23-09-1F-07-83-01-00-00-02-3A-80-18-71-38-2D-40-58-2C-45-00-55-50-21-00-00-1E-7E-39-00-A0-80-38-1F-40-30-20-3A-00-55-50-21-00-00-1A-01-1D-00-72-51-D0-1E-20-6E-28-55-00-55-50-21-00-00-1E-BF-16-00-A0-80-38-13-40-30-20-3A-00-55-50-21-00-00-1A-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-00-72 
#Create /rw/dbedidoverride0.txt and delete /rw/dbedidoverride1.txt /rw/dbedidoverride2.txt /rw/dbedidoverride3.txt
edidoverride0_IsPresent=false
edidoverride1_IsPresent=false
edidoverride2_IsPresent=false
edidoverride3_IsPresent=false

#high-level token to disable the edid pass-through.
disablepassthrough0_IsPresent=false
disablepassthrough1_IsPresent=false
disablepassthrough2_IsPresent=false
disablepassthrough3_IsPresent=false

#high-level token for custom conf
customconf=false
conflocation="/rw/config/modprobe.d/sv2.conf"

extended_logging_at_shutdown_IsPresent=false
extended_logging_at_shutdown=0
collect_full_journal_IsPresent=false

netbonding_xmsl_arp_management_IsPresent=false
netbonding_miimon_IsPresent=false
netbonding_arp_interval_IsPresent=false
netbonding_arp_lost_interval_IsPresent=false
netbonding_arp_lost_interval_duration_IsPresent=false
netbonding_arp_validate_IsPresent=false
netbonding_arp_all_targets_IsPresent=false
netbonding_debug_IsPresent=false
netbonding_arp_slave_switch_interval_IsPresent=false

# Extio3 USB monitor 
usbmon_IsPresent=false

# Disable Extio3 IPsec pcrypt
nopcrypt_IsPresent=false

# XMSL log level override
xmsl_loglevel_IsPresent=false

# check is we have to restart for systemRestartFunction()
restartMainService=false

systemRestartFunction() {
    if [[ -f "/lib/systemd/system/extio3_rx.service" ]]
    then 
        #echo "device is rx"
        systemctl restart extio3_rx
    else
        systemctl restart extio3_tx
        #echo "device is tx"
    fi
}

for var in "$@"
do

    if [ $var == "hlt_sdbc" ]; then
        hlt_sdbc_IsPresent=true
    fi

    if [ $var == "hlt_sadd" ]; then
        hlt_sadd_IsPresent=true
    fi

    if [ "$(echo $var | rev | cut -d'_' -f2- | rev)" = "hlt_debuginterface" ]; then
        hlt_debuginterface_IsPresent=true
        hlt_debuginterface=$(echo $var | cut -f3 -d'_')
    fi

    if [ "$var" = "hlt_efl" ]; then
        hlt_efl_IsPresent=true
    fi

    if [ "$var" = "hlt_esl" ]; then
        hlt_esl_IsPresent=true
    fi

    if [ "$var" = "HdcpCheck" ]; then
        HdcpCheck=true
    fi
    
    if [ "$var" = "sview" ]; then
        sview=true
    fi    
    
    if [ "$var" = "ScdcCheck" ]; then
        ScdcCheck=true
    fi

    if [ "$var" = "HideNoSignal" ]; then
        HideNoSignal=true
    fi

    if [ "$var" = "DoNotUseVirtualUsbDevices" ]; then
        DoNotUseVirtualUsbDevices=true
    fi

    if [ "$var" = "MtxEventTracer" ]; then
        MtxEventTracer=true
    fi

    if [ "$var" = "RGB_limited_workaround_disable" ]; then
        RGB_limited_workaround_disable=true
    fi

    if [ "$var" = "hlt_dm" ]; then
        hlt_dm_IsPresent=true
    fi

    if [ "$var" = "hlt_etl" ]; then
        hlt_etl_IsPresent=true
    fi

    if [ "$var" = "hlt_edbc" ]; then
        hlt_edbc=true
    fi

    if [ "$var" = "ResetFpga" ]; then
        /bin/date >> /rw/logs/ResetFpga.log
        /bin/sync
        /bin/bash -c "/usr/local/bin/ResetFpga.sh"
    fi

    if [ "$var" = "hlt_xll0" ]; then
        hlt_xll0=true
    fi

    if [ "$var" = "hlt_xll1" ]; then
        hlt_xll1=true
    fi

    if [ "$var" = "hlt_xll2" ]; then
        hlt_xll2=true
    fi

    if [ "$var" = "hlt_xll3" ]; then
        hlt_xll3=true
    fi

    if [ "$var" = "hlt_xll4" ]; then
        hlt_xll4=true
    fi

    if [ "$var" == "hlt_pcc" ]; then
        hlt_pcc_IsPresent=true
    fi

    if [ "$var" = "hlt_vsv" ]; then
        hlt_vsv=true
    fi    

    if [ "$var" = "hlt_adng" ]; then
        hlt_adng=true
    fi    

    if [ "$(echo $var | cut -f1 -d'_')" = "edidoverride0" ]; then
        edidoverride0_IsPresent=true
        edidoverride0=$(echo $var | cut -f2 -d'_')
    fi

    if [ "$(echo $var | cut -f1 -d'_')" = "edidoverride1" ]; then
        edidoverride1_IsPresent=true
        edidoverride1=$(echo $var | cut -f2 -d'_')
    fi

    if [ "$(echo $var | cut -f1 -d'_')" = "edidoverride2" ]; then
        edidoverride2_IsPresent=true
        edidoverride2=$(echo $var | cut -f2 -d'_')
    fi

    if [ "$(echo $var | cut -f1 -d'_')" = "edidoverride3" ]; then
        edidoverride3_IsPresent=true
        edidoverride3=$(echo $var | cut -f2 -d'_')
    fi

    if [ "$(echo $var | cut -f2 -d'_')" = "disablepassthrough0" ]; then
        disablepassthrough0_IsPresent=true
    fi

    if [ "$(echo $var | cut -f2 -d'_')" = "disablepassthrough1" ]; then
        disablepassthrough1_IsPresent=true
    fi

    if [ "$(echo $var | cut -f2 -d'_')" = "disablepassthrough2" ]; then
        disablepassthrough2_IsPresent=true
    fi

    if [ "$(echo $var | cut -f2 -d'_')" = "disablepassthrough3" ]; then
        disablepassthrough3_IsPresent=true
    fi

    if [[ $var == conf__* ]]; then
        customconf=true
        confcommand="options sv2 `echo $var | cut -c7- | sed -r 's/-+/=/g' | sed -r 's/__+/ /g'`"
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "extended_logging_at_shutdown" ]; then
        extended_logging_at_shutdown_IsPresent=true
        extended_logging_at_shutdown=$(echo $var | rev | cut -f1 -d'_')
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_xmsl_arp_management" ]; then
        netbonding_xmsl_arp_management_IsPresent=true
        netbonding_xmsl_arp_management=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_miimon" ]; then
        netbonding_miimon_IsPresent=true
        netbonding_miimon=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_arp_interval" ]; then
        netbonding_arp_interval_IsPresent=true
        netbonding_arp_interval=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_arp_lost_interval" ]; then
        netbonding_arp_lost_interval_IsPresent=true
        netbonding_arp_lost_interval=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_arp_lost_interval_duration" ]; then
        netbonding_arp_lost_interval_duration_IsPresent=true
        netbonding_arp_lost_interval_duration=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_arp_validate" ]; then
        netbonding_arp_validate_IsPresent=true
        netbonding_arp_validate=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_arp_all_targets" ]; then
        netbonding_arp_all_targets_IsPresent=true
        netbonding_arp_all_targets=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_debug" ]; then
        netbonding_debug_IsPresent=true
        netbonding_debug=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "netbonding_arp_slave_switch_interval" ]; then
        netbonding_arp_slave_switch_interval_IsPresent=true
        netbonding_arp_slave_switch_interval=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

    if [ "$var" = "usbmon" ]; then
        usbmon_IsPresent=true
    fi

    if [ "$var" = "collect_full_journal" ]; then
        collect_full_journal_IsPresent=true
    fi

    if [ "$var" = "nopcrypt" ];  then
        nopcrypt_IsPresent=true
    fi

    if [ "$(echo $var | rev | cut -f2- -d'_' | rev)" = "xmsl_loglevel" ]; then
        xmsl_loglevel_IsPresent=true
        xmsl_loglevel=$(echo $var | rev | cut -f1 -d'_' | rev)
    fi

done 

if $sview; then
    touch /rw/config/sview
else
    rm -f /rw/config/sview
fi

if $HdcpCheck; then
    touch /rw/config/HdcpCheck
else
    rm -f /rw/config/HdcpCheck
fi

if $ScdcCheck; then
    touch /rw/config/ScdcCheck
else
    rm -f /rw/config/ScdcCheck
fi

if $HideNoSignal; then
    touch /rw/config/HideNoSignal
else
    rm -f /rw/config/HideNoSignal
fi

if $DoNotUseVirtualUsbDevices; then
    touch /rw/config/DoNotUseVirtualUsbDevices
else
    rm -f /rw/config/DoNotUseVirtualUsbDevices
fi

if $RGB_limited_workaround_disable; then
    touch /rw/config/RGB_limited_workaround_disable
else
    rm -f /rw/config/RGB_limited_workaround_disable
fi

if $MtxEventTracer; then
    echo "1" > /rw/config/MtxEventTracer.txt
else
    rm -f /rw/config/MtxEventTracer.txt
    rm -f /rw/logs/MtxEventTracerOutput.dat
fi

if $hlt_sdbc_IsPresent; then
    if [ ! -f /rw/config/show_debug_background_color ]; then 
        touch /rw/config/show_debug_background_color
        restartMainService=true
    fi
else
    if  [ -f /rw/config/show_debug_background_color ]; then
        rm -f /rw/config/show_debug_background_color
        restartMainService=true
    fi
fi

if $hlt_sadd_IsPresent; then
    if [ ! -f /rw/config/show_auto_disconnection_details ]; then
        touch /rw/config/show_auto_disconnection_details
        restartMainService=true
    fi
else
    if [ -f /rw/config/show_auto_disconnection_details ]; then
        rm -f /rw/config/show_auto_disconnection_details
        restartMainService=true
    fi
fi

rm -f /rw/config/EnableSecondEthernetInterface

if $hlt_debuginterface_IsPresent; then
    if [ -f /usr/local/bin/enable-sec-interface-debug.sh ]; then
        /usr/local/bin/enable-sec-interface-debug.sh $hlt_debuginterface
        restartMainService=true
    fi
fi

if $hlt_efl_IsPresent; then
    sed -i 's/<!--appender-ref ref="CompleteFileAppender"\/-->/<appender-ref ref="CompleteFileAppender"\/>/' $sv2_device_config_file
else
    sed -i 's/<appender-ref ref="CompleteFileAppender"\/>/<!--appender-ref ref="CompleteFileAppender"\/-->/' $sv2_device_config_file
fi

if $hlt_esl_IsPresent; then
    sed -i 's/<!--appender-ref ref="StatisticsAppender"\/-->/<appender-ref ref="StatisticsAppender"\/>/' $sv2_device_config_file
else
    sed -i 's/<appender-ref ref="StatisticsAppender"\/>/<!--appender-ref ref="StatisticsAppender"\/-->/' $sv2_device_config_file
fi

if $hlt_edbc; then
    touch /rw/config/use_debug_background_colors
else
    rm -f /rw/config/use_debug_background_colors
fi

if $hlt_dm_IsPresent; then 
    if [ ! -f /rw/config/DisableMaQoS ]; then
        touch /rw/config/DisableMaQoS
        restartMainService=true
    fi
else
    if [ -f /rw/config/DisableMaQoS ]; then
        rm -f /rw/config/DisableMaQoS
        restartMainService=true
    fi
fi

if $hlt_pcc_IsPresent; then 
    if  [ ! -f /rw/config/EnablePeriodicCompositorCapture ]; then
        touch /rw/config/EnablePeriodicCompositorCapture
        restartMainService=true
    fi
else
    if  [ -f /rw/config/EnablePeriodicCompositorCapture ]; then
        rm -f /rw/config/EnablePeriodicCompositorCapture
        restartMainService=true
    fi
fi

if $hlt_etl_IsPresent; then
    if [ ! -f /rw/config/EnableTimingLogging ]; then
        touch /rw/config/EnableTimingLogging
        restartMainService=true
    fi
else
    if [ -f /rw/config/EnableTimingLogging ]; then
        rm -f /rw/config/EnableTimingLogging
        restartMainService=true
    fi
fi

if $hlt_adng; then
    if [ ! -f /rw/config/use_legacy_ad_validation ]; then
        touch /rw/config/use_legacy_ad_validation
        restartMainService=true
    fi
else
    if [ -f /rw/config/use_legacy_ad_validation ]; then
        rm -f /rw/config/use_legacy_ad_validation
        restartMainService=true
    fi
fi

if $hlt_xll0; then
    touch $rw_config_simple_setting
    if grep -q "XmslLogLevel" $rw_config_simple_setting; then
        if ! grep -q "XmslLogLevel=0" $rw_config_simple_setting; then
            sed -i 's/XmslLogLevel=[0-4]/XmslLogLevel=0/' $rw_config_simple_setting
            restartMainService=true
        fi
    else
        echo "XmslLogLevel=0" >> $rw_config_simple_setting
        restartMainService=true
    fi
fi

if $hlt_xll1; then
    touch $rw_config_simple_setting
    if grep -q "XmslLogLevel" $rw_config_simple_setting; then
        if ! grep -q "XmslLogLevel=1" $rw_config_simple_setting; then
            sed -i 's/XmslLogLevel=[0-4]/XmslLogLevel=1/' $rw_config_simple_setting
            restartMainService=true
        fi
    else
        echo "XmslLogLevel=1" >> $rw_config_simple_setting
        restartMainService=true
    fi
fi

if $hlt_xll2; then
    touch $rw_config_simple_setting
    if grep -q "XmslLogLevel" $rw_config_simple_setting; then
        if ! grep -q "XmslLogLevel=2" $rw_config_simple_setting; then
            sed -i 's/XmslLogLevel=[0-4]/XmslLogLevel=2/' $rw_config_simple_setting
            restartMainService=true
        fi
    else
        echo "XmslLogLevel=2" >> $rw_config_simple_setting
        restartMainService=true
    fi
fi

if $hlt_xll3; then
    touch $rw_config_simple_setting
    if grep -q "XmslLogLevel" $rw_config_simple_setting; then
        if ! grep -q "XmslLogLevel=3" $rw_config_simple_setting; then
            sed -i 's/XmslLogLevel=[0-4]/XmslLogLevel=3/' $rw_config_simple_setting
            restartMainService=true
        fi
    else
        echo "XmslLogLevel=3" >> $rw_config_simple_setting
        restartMainService=true
    fi
fi

if $hlt_xll4; then
    touch $rw_config_simple_setting
    if grep -q "XmslLogLevel" $rw_config_simple_setting; then
        if ! grep -q "XmslLogLevel=4" $rw_config_simple_setting; then
            sed -i 's/XmslLogLevel=[0-4]/XmslLogLevel=4/' $rw_config_simple_setting
            restartMainService=true
        fi
    else
        echo "XmslLogLevel=4" >> $rw_config_simple_setting
        restartMainService=true
    fi
fi

if $edidoverride0_IsPresent; then
    echo $edidoverride0 > /rw/config/dbedidoverride0.txt
else
    rm -f /rw/config/dbedidoverride0.txt
fi

if $edidoverride1_IsPresent; then
    echo $edidoverride1 > /rw/config/dbedidoverride1.txt
else
    rm -f /rw/config/dbedidoverride1.txt
fi

if $edidoverride2_IsPresent; then
    echo $edidoverride2 > /rw/config/dbedidoverride2.txt
else
    rm -f /rw/config/dbedidoverride2.txt
fi

if $edidoverride3_IsPresent; then
    echo $edidoverride3 > /rw/config/dbedidoverride3.txt
else
    rm -f /rw/config/dbedidoverride3.txt
fi

if [ -f /usr/local/bin/LEdidOverride.sh ]; then
    /usr/local/bin/LEdidOverride.sh
fi

if $disablepassthrough0_IsPresent; then
    touch /rw/config/dbLMvxEdidManager_disablepassthrough0
else
    rm -f /rw/config/dbLMvxEdidManager_disablepassthrough0
fi

if $disablepassthrough1_IsPresent; then
    touch /rw/config/dbLMvxEdidManager_disablepassthrough1
else
    rm -f /rw/config/dbLMvxEdidManager_disablepassthrough1
fi

if $disablepassthrough2_IsPresent; then
    touch /rw/config/dbLMvxEdidManager_disablepassthrough2
else
    rm -f /rw/config/dbLMvxEdidManager_disablepassthrough2
fi

if $disablepassthrough3_IsPresent; then
    touch /rw/config/dbLMvxEdidManager_disablepassthrough3
else
    rm -f /rw/config/dbLMvxEdidManager_disablepassthrough3
fi

if [ ${hlt_vsv} ]; then
    ln -sf /usr/local/debug/vital_signs /rw/debug/vital_signs
    ln -sf /tmp/debug/vital_signs_data /rw/debug/vital_signs_data
else
    if [ -L /rw/debug/vital_signs ]; then
        unlink /rw/debug/vital_signs
    fi
    if [ -L /rw/debug/vital_signs_data ]; then
        unlink /rw/debug/vital_signs_data
    fi
fi

if $customconf; then
    while read -r line
    do    
        if [[ $line == "#confbackup"* ]]; then
            confbackup=$line
            break
        else
            confbackup="#confbackup $line"
        fi
    done < "$conflocation"
    cat >$conflocation <<EOL
$confbackup
$confcommand
EOL
else
    while read -r line
    do
        if [[ $line == "#confbackup"* ]]; then
        echo "`echo $line | cut -c13-`" > $conflocation
        break
        fi
    done < "$conflocation"
fi

if $extended_logging_at_shutdown_IsPresent; then
    if [ "$extended_logging_at_shutdown" = "0" ]; then
        echo 0 > /rw/config/extended_logging_at_shutdown.conf
    else
        echo 1 > /rw/config/extended_logging_at_shutdown.conf
    fi
else
    rm -f /rw/config/extended_logging_at_shutdown.conf
fi

if $collect_full_journal_IsPresent; then
    touch /rw/config/collect_full_journal.conf
else
    rm -f /rw/config/collect_full_journal.conf
fi

rm -f /rw/config/network_bonding.conf

if $netbonding_xmsl_arp_management_IsPresent; then
    echo "xmsl_arp_management=$netbonding_xmsl_arp_management" >> /rw/config/network_bonding.conf
fi

if $netbonding_miimon_IsPresent; then
    echo "miimon=$netbonding_miimon" >> /rw/config/network_bonding.conf
fi

if $netbonding_arp_interval_IsPresent; then
    echo "arp_interval=$netbonding_arp_interval" >> /rw/config/network_bonding.conf
fi

if $netbonding_arp_lost_interval_IsPresent; then
    echo "arp_lost_interval=$netbonding_arp_lost_interval" >> /rw/config/network_bonding.conf
fi

if $netbonding_arp_lost_interval_duration_IsPresent; then
    echo "arp_lost_interval_duration=$netbonding_arp_lost_interval_duration" >> /rw/config/network_bonding.conf
fi

if $netbonding_arp_validate_IsPresent; then
    echo "arp_validate=$netbonding_arp_validate" >> /rw/config/network_bonding.conf
fi

if $netbonding_arp_all_targets_IsPresent; then
    echo "arp_all_targets=$netbonding_arp_all_targets" >> /rw/config/network_bonding.conf
fi

if $netbonding_debug_IsPresent; then
    echo "debug=$netbonding_debug" >> /rw/config/network_bonding.conf
fi

if $netbonding_arp_slave_switch_interval_IsPresent; then
    echo "arp_slave_switch_interval=$netbonding_arp_slave_switch_interval" >> /rw/config/network_bonding.conf
fi

if $usbmon_IsPresent; then
    if [ -f /lib/systemd/system/usbmon.service ]; then
        systemctl start usbmon
    fi
else
    if [ -f /lib/systemd/system/usbmon.service ]; then
        systemctl stop usbmon
    fi
fi

if $nopcrypt_IsPresent; then
    echo "nopcrypt=1" > /rw/config/pcrypt.conf
else
    rm -f /rw/config/pcrypt.conf
fi

# Flush any existing line starting with "loglevel=".
sed -i '/^loglevel=/d' /rw/config/xmsl.conf > /dev/null 2>&1
if $xmsl_loglevel_IsPresent; then
    echo "loglevel=${xmsl_loglevel}" >> /rw/config/xmsl.conf
fi

if $restartMainService;
then
    systemRestartFunction
fi
